package com.burhanstore.neonbubblequest.Utils.anim

import android.app.Activity
import android.view.View
import com.burhanstore.neonbubblequest.R

object AnimationHelper {

    fun applyZoomTransition(activity: Activity) {
        activity.overridePendingTransition(R.anim.zoom_in, R.anim.zoom_out)
    }

    fun applySlideUpTransition(activity: Activity) {
        activity.overridePendingTransition(R.anim.slide_in_up, R.anim.slide_out_down)
    }

    fun applySlideRightTransition(activity: Activity) {
        activity.overridePendingTransition(R.anim.slide_in_right, R.anim.slide_out_left)
    }

    fun applySlideZoomTransition(activity: Activity) {
        activity.overridePendingTransition(R.anim.fade_in, R.anim.fade_out)
    }


    /**
     * 🔹 Smooth press animation with double-click protection.
     * Use: myButton.setClickWithAnimation { /* your code */ }
     */
    fun View.setOnClick(onClick: () -> Unit) {
        this.setOnClickListener {
            // Prevent multiple fast clicks
            this.isEnabled = false

            this.animate()
                .scaleX(0.94f)
                .scaleY(0.94f)
                .setDuration(100)
                .withEndAction {
                    this.animate()
                        .scaleX(1f)
                        .scaleY(1f)
                        .setDuration(100)
                        .withEndAction {
                            this.isEnabled = true
                            onClick()
                        }
                        .start()
                }
                .start()
        }
    }

    /**
     * 🔹 Optional: Bounce animation style
     * Use: myButton.setBounceClickAnimation { /* your code */ }
     */
    fun View.setBounceClickAnimation(onClick: () -> Unit) {
        this.setOnClickListener {
            this.animate()
                .scaleX(0.9f)
                .scaleY(0.9f)
                .setDuration(120)
                .withEndAction {
                    this.animate()
                        .scaleX(1f)
                        .scaleY(1f)
                        .setDuration(120)
                        .withEndAction {
                            onClick()
                        }
                        .start()
                }
                .start()
        }
    }

}
